/* gridView */

#import <Cocoa/Cocoa.h>
#import <QuickTime/QuickTime.h>
#import <AppKit/AppKit.h>
#import <AudioToolbox/AudioToolbox.h>

@interface gridView : NSView
{
	
    IBOutlet id bars;
    IBOutlet id beats;
    IBOutlet id bass;
    IBOutlet id pitch;
    IBOutlet id clear;
    IBOutlet id undo;
    IBOutlet id div;
    IBOutlet id mid;
    IBOutlet id qt;
    IBOutlet id reg;
    IBOutlet id count;
    
    IBOutlet id dr1Test;
    IBOutlet id dr1Vel;
    IBOutlet id dr2Test;
    IBOutlet id dr2Vel;
    IBOutlet id dr3Test;
    IBOutlet id dr3Vel;
    IBOutlet id dr4Test;
    IBOutlet id dr4Vel;
    IBOutlet id dr5Test;
    IBOutlet id dr5Vel;
    IBOutlet id dr6Vel;
    IBOutlet id dr6Test;
    IBOutlet id dr7Test;
    IBOutlet id dr7Vel;
    IBOutlet id dr8Test;
    IBOutlet id dr8Vel;
    IBOutlet id dr9Test;
    IBOutlet id dr9Vel;
    IBOutlet id dr10Test;
    IBOutlet id dr10Vel;
    IBOutlet id dr11Test;
    IBOutlet id dr11Vel;
    IBOutlet id dr12Test;
    IBOutlet id dr12Vel;
    IBOutlet id def;
    IBOutlet id grid;
    IBOutlet id kit;
    IBOutlet id inf;
    IBOutlet id play;
    IBOutlet id preset;
    IBOutlet id prev;
	IBOutlet id pos;
	IBOutlet id save;
	IBOutlet id open;
    IBOutlet id drumSave;
	IBOutlet id drumOpen;
    
    IBOutlet NSSlider    *tempoSlider;
    IBOutlet NSTextField *tempoField;
    IBOutlet NSTextField *drSET;
    IBOutlet NSTextField *kitField;
    
    IBOutlet NSTextField *fileField;
    IBOutlet NSTextField *vol1Field;
    IBOutlet NSTextField *vol2Field;
    IBOutlet NSTextField *vol3Field;
    IBOutlet NSTextField *vol4Field;
    IBOutlet NSTextField *vol5Field;
    IBOutlet NSTextField *vol6Field;
    IBOutlet NSTextField *vol7Field;
    IBOutlet NSTextField *vol8Field;
    IBOutlet NSTextField *vol9Field;
    IBOutlet NSTextField *vol10Field;
    IBOutlet NSTextField *vol11Field;
    IBOutlet NSTextField *vol12Field;
    
    IBOutlet id dr1;
    IBOutlet id dr2;
    IBOutlet id dr3;
    IBOutlet id dr4;
    IBOutlet id dr5;
    IBOutlet id dr6;
    IBOutlet id dr7;
    IBOutlet id dr8;
    IBOutlet id dr9;
    IBOutlet id dr10;
    IBOutlet id dr11;
    IBOutlet id dr12;
    
    IBOutlet NSTextField *drum1Field;
    IBOutlet NSTextField *drum2Field;
    IBOutlet NSTextField *drum3Field;
    IBOutlet NSTextField *drum4Field;
    IBOutlet NSTextField *drum5Field;
    IBOutlet NSTextField *drum6Field;
    IBOutlet NSTextField *drum7Field;
    IBOutlet NSTextField *drum8Field;
    IBOutlet NSTextField *drum9Field;
    IBOutlet NSTextField *drum10Field;
        
    IBOutlet NSTextField *X;
    IBOutlet NSTextField *Y;
    IBOutlet NSTextField *gridField;
}


- (IBAction)playGroove:(id)sender;
- (IBAction)setBars:(id)sender;
- (IBAction)cleanBufs:(id)sender;
- (IBAction)undoClear:(id)sender;
- (IBAction)setRegister:(id)sender;
- (IBAction)quit:(id)sender;
//- (IBAction)setPitch:(id)sender;

- (IBAction)setD1vol:(id)sender;
- (IBAction)setD2vol:(id)sender;
- (IBAction)setD3vol:(id)sender;
- (IBAction)setD4vol:(id)sender;
- (IBAction)setD5vol:(id)sender;
- (IBAction)setD6vol:(id)sender;
- (IBAction)setD7vol:(id)sender;
- (IBAction)setD8vol:(id)sender;
- (IBAction)setD9vol:(id)sender;
- (IBAction)setD10vol:(id)sender;

- (IBAction)setDiv:(id)sender;

- (IBAction)setDrum1:(id)sender;
- (IBAction)setDrum2:(id)sender;
- (IBAction)setDrum3:(id)sender;
- (IBAction)setDrum4:(id)sender;
- (IBAction)setDrum5:(id)sender;
- (IBAction)setDrum7:(id)sender;
- (IBAction)setDrum8:(id)sender;
- (IBAction)setDrum9:(id)sender;
- (IBAction)setDrum10:(id)sender;

- (IBAction)setDefaults:(id)sender;
- (IBAction)setPrev:(id)sender;
- (IBAction)doRandom:(id)sender;
- (IBAction)setKit:(id)sender;
- (IBAction)setTempo:(id)sender;
- (IBAction)setTest:(id)sender;
- (IBAction)setBeats:(id)sender;
- (IBAction)doPreset:(id)sender;
- (IBAction)setPos:(id)sender;
- (IBAction)saveFile:(id)sender;
- (IBAction)openFile:(id)sender;
- (IBAction)saveDrums:(id)sender;
- (IBAction)openDrums:(id)sender;
- (IBAction)saveMIDI:(id)sender;
- (IBAction)fixQT:(id)sender;

- (void)mouseDown:(NSEvent *)event;
- (void)keyDown:(NSEvent *)event;

- (void)displayDrums;
- (void)displayNotes;
- (void)displayVolume;


// Variables ====================================================================================================

int key, G, left, TEMPO, TP, BEATS, BP, DRUMS, BEATS, BARS, SUB, RHYTHM, BS, DRC, DRV, DRS, QT, CNT;
int DR1, DR2, DR3, DR4, DR5, DR6, DR7, DR8, DR9, DR10, DR11, DR12;
int DV1, DV2, DV3, DV4, DV5, DV6, DV7, DV8, DV9, DV10, DV11, DV12;
int oldV1, oldV2, oldV3, oldV4, oldV5, oldV6, oldV7, oldV8, oldV9, oldV10;
int oldD1, oldD2, oldD3, oldD4, oldD5, oldD6, oldD7, oldD8, oldD9, oldD10;
int KIT, oldKIT, event, DEMO, GRID, TOG, TOG2, PRE, POS, LNG, LOOP;
int velTOG, randTOG, colTOG, undoTOG, dataTOG, saveSET, exportMIDI, INF;
int DEMO = 3;
long subdiv;

NSPoint pt, p; NSMutableArray * midi; NSNumber *data;

NSString * TITLE     = @"Bossa";
NSString * lastFile  = @"Groove";
NSString * helptext  = @"\n\nClick within a BOX to set a drum note; click a filled BOX again to erase it; tap delete to clear all boxes; Tap U to undo the clear\n\nTap the SPACEBAR to Play/Stop example.\n\nTap < or > to change Tempo\n\nTap R to Randomly fill BOXES with slider Volume.\nOpt/R = Random Volume only.\nCtrl/R = Both Random Box Fill & Volume.\nTap the D key for Random Drums only.\nTap the A key for ALL random settings.\nTap the I key to toggle Infinite Randomise.\n\nTap V to toggle Display Volume.\n\nAfter selecting a drum with a number key or by clicking a drum button, you can increment or decrement that drum selection with the Left and Right arrows.\n\nOr, doing the same, you can increment or decrement the volume of that drum selection with the Up and Down arrows.\n\nTo toggle a drum OFF and On with its previous volume, tap the drum number key while holding down the Opt. key.\n\nClick the Set Vol button to set any changes in individual volumes.\n\nSet the number of bars with the [ and ] keys.\n\nCom/S = Save groove, Opt/S = Save drum set;\nCom/O = Open groove, Opt/O = Open drum set;\nCntrl/S = Save MIDI."; 
NSString * DRnames   = @"BassDrum2,BassDrum1,SideStick,AccSnare,Clap,ElecSnare,Lo Floor Tom,Closed Hat,High Tom,Pedal Hat,Low Tom,Open Hat,Lo/Mid Tom,Hi/Mid Tom,Crash 1,High Tom,Ride 1,Chinese,Ride Bell,Tambourine,Splash,Cowbell,Crash 2,Vibraslap,Ride 2,Hi Bongo,Low Bongo,Muted Conga,Open Conga,Low Conga,Hi Timbale,Lo Timbale,Lo Agogo,Hi Agogo,Shaker 1,Shaker 2,S Whistle,L Whistle,Scraper 1,Scraper 2,Wood Block1,Wood Block2,Low Wood,Quicka 1,Quicka 2,Choked Tri,Open Tri,Shaker 2,Sleigh Bells,Slide Bells,????,!!!!,FUCK";
NSString * roots     = @"B1,C2,Db2,D2,Eb2,E2,F2,Gb2,G2,Ab2,A2,Bb2,B2,C3,Db3,D3,Eb3,E3,F3,Gb3,G3,Ab3,A3,Bb3,B3,C4,Db4,D4,Eb4,E4,F4,Gb4,G4,Ab4,A4,Bb4,B4,C5,Db5,D5,Eb5,E5,F5,Gb5,G5,Ab5,A5,Bb5,B5,C5,Db5,D5,Eb5,E5,F5,Gb5,G5,Ab5,A5,Bb5,B5,C6";

int DR1BUF[80];   int DR1undo[80];   int DR1undo2[80];      int DR1VOL[80];
int DR2BUF[80];   int DR2undo[80];   int DR2undo2[80];      int DR2VOL[80];
int DR3BUF[80];   int DR3undo[80];   int DR3undo2[80];      int DR3VOL[80];
int DR4BUF[80];   int DR4undo[80];   int DR4undo2[80];      int DR4VOL[80];
int DR5BUF[80];   int DR5undo[80];   int DR5undo2[80];      int DR5VOL[80];
int DR6BUF[80];   int DR6undo[80];   int DR6undo2[80];      int DR6VOL[80];
int DR7BUF[80];   int DR7undo[80];   int DR7undo2[80];      int DR7VOL[80];
int DR8BUF[80];   int DR8undo[80];   int DR8undo2[80];      int DR8VOL[80];
int DR9BUF[80];   int DR9undo[80];   int DR9undo2[80];      int DR9VOL[80];
int DR10BUF[80];  int DR10undo[80];  int DR10undo2[80];     int DR10VOL[80];

int JAZZ3[4][18] = { 
{ 50,00,00, 40,00,50, 60,00,00, 40,50,00, 40,00,50, 40,00,40 },
{ 00,00,00, 70,00,00, 00,00,00, 00,00,00, 70,00,00, 00,60,00 },
{ 00,50,00, 00,00,00, 00,00,00, 00,50,00, 00,00,00, 00,00,00 },
{ 40,00,00, 00,00,00, 00,00,40, 40,00,00, 00,00,00, 40,00,00 } };

int LATIN3[4][12] = { 
{ 50,60,00,70,00,50, 50,60,00,70,00,70 },
{ 00,00,60,00,70,00, 00,00,60,00,70,00 },
{ 00,60,00,60,00,00, 00,60,00,60,00,00 },
{ 70,00,00,00,00,60, 70,00,00,00,00,60 } };

int BOSSA[4][16] = {
{ 60,50,60,70,00,40,50,60, 50,60,00,40,50,50,60,50 },
{ 00,50,70,00,00,00,70,00, 00,50,70,00,00,00,70,00 },
{ 50,00,00,60,00,00,70,00, 00,00,50,00,00,70,00,00 },
{ 60,00,00,00,00,00,00,40, 60,00,00,50,00,00,00,40 } };  

int SOUL[4][24] = { 
{ 40,00,00, 40,00,00, 50,00,00, 40,00,40,  50,00,00, 40,00,00, 40,00,50, 40,00,40 },
{ 00,00,00, 70,00,00, 00,00,00, 70,00,00,  00,00,00, 70,00,00, 00,00,00, 70,00,00  },
{ 00,00,00, 00,00,00, 00,00,00, 70,00,00,  00,00,00, 00,00,00, 00,00,00, 70,00,00  },
{ 00,00,00, 60,00,70, 00,00,00, 00,00,00,  00,00,00, 60,00,70, 00,00,00, 00,00,00  } };

int FUNK1[4][32] = {
{ 50,60,70,00, 00,00,70,00, 50,70,00,00, 00,00,60,00,  50,60,70,00, 00,00,50,00, 40,00,50,00, 70,00,50,00 },
{ 70,70,00,00, 70,00,00,00, 70,00,00,00, 50,70,00,00,  70,00,00,00, 70,00,00,00, 70,70,00,00, 70,00,00,00 },
{ 00,00,00,00, 70,00,00,00, 00,00,00,00, 70,00,00,00,  00,00,00,00, 70,00,00,00, 00,00,00,00, 70,00,00,00 },
{ 70,00,00,00, 00,00,70,00, 70,00,00,00, 00,00,00,50,  70,70,00,00, 00,00,50,00, 70,00,00,00, 00,00,00,50 } };

 int SALSA[4][16] = {
{ 50,40,40,60, 00,40,00,50, 60,40,40,50, 00,40,00,40 },
{ 50,00,00,50, 60,00,00,00, 50,00,00,50, 00,00,60,00 },
{ 50,00,00,40, 00,00,50,00, 00,00,50,00, 00,50,00,00 },
{ 30,00,40,00, 30,40,00,40, 40,00,00,40, 30,40,50,00 } }; 

int LATIN5[4][20] = {
{ 30,00,20,00,30,40,00,50,00,40, 30,00,00,50,50,60,00,60,00,40 },
{ 20,30,00,20,00,50,00,00,60,00, 00,30,00,20,00,50,00,00,60,00 },
{ 30,00,00,60,00,00,60,00,60,00, 30,00,00,60,00,00,60,00,60,00 },
{ 60,00,00,40,50,00,40,00,50,00, 60,00,00,40,30,50,40,00,50,00 } }; 

int ECM[4][32] = { 
{ 50,00,40,64, 60,00,50,00, 50,64,70,00, 50,00,40,50,  40,50,00,40, 60,00,40,40, 50,00,60,40, 50,00,40,50 },
{ 00,00,00,70, 00,00,00,00, 00,00,00,00, 00,00,00,00,  00,00,00,70, 00,00,00,70, 00,00,00,00, 00,00,00,00 },
{ 00,70,00,00, 00,00,00,00, 00,00,00,00, 00,00,00,00,  00,70,00,00, 00,00,00,00, 00,00,00,00, 00,00,00,00 },
{ 40,00,00,00, 00,50,00,00, 00,00,00,00, 00,50,00,40,  50,00,00,00, 00,60,00,00, 00,00,00,00, 00,40,00,00 } };


// TIMER stuff ============================================================

 NSTimeInterval lastTime;
 NSTimer*	mTimer;
    
- (void)respondToTimer:(NSTimer *)timer;

// QUICKTIME stuff ============================================================

    NoteAllocator   na;
    NoteRequest     nr;
    NoteChannel     nc;
    ComponentResult er;
        
enum {
kNoteAllocatorType = 'nota'
};

@end
